;***  SOURCE FOR 'WAVESCROLLER' SCREEN   ***
;*** WRITTEN BY STALIN OF FLEXIBLE FRONT ***
;***     FOR THE WHATTAHECK DEMO-89      ***
;***    RUNS WITH ASSEMPRO ASSEMBLER     ***

 BRA START
SCR=$F8000            ;$78000 FOR 520
SCR1=$F0000           ;$70000 FOR 520
CHARS=ASCSLUT-ASCCI

SCRBUF:
 DS.B 3000,0

START:
 CLR.L -(SP)
 MOVE.W #$20,-(SP)
 TRAP #1
 ADDQ.L #6,SP
 MOVE.L D0,SSP

 MOVE.W #0,-(SP)
 PEA SCR
 PEA SCR
 MOVE.W #5,-(SP)
 TRAP #14
 ADD.L #12,SP

 LEA SCR,A0
 LEA SCR1,A1
 MOVE.W #7999,D0
 BSR COPY

 LEA $FF8240,A0
 LEA OLPAL,A1
 MOVEQ #7,D0
 BSR COPY
 LEA PAL,A0
 LEA $FF8240,A1
 MOVEQ #7,D0
 BSR COPY

 PEA ALLOFF
 MOVE.W #1,-(SP)
 MOVE.W #25,-(SP)
 TRAP #14
 ADDQ.L #8,SP

; MOVE.W #6,-(SP)
; MOVE.W #26,-(SP)
; TRAP #14
; ADDQ.L #4,SP

 MOVE.W #5,-(SP)
 MOVE.W #26,-(SP)
 TRAP #14
 ADDQ.L #4,SP

 BSR INITRAST
 BSR PRESCROLL
 MOVEQ #0,D0
 JSR MUSIC
 MOVE.W #$2700,SR
 MOVE.L $70,OVBL
 MOVE.L #VBL,$70
 MOVE.W #$2300,SR

FOREVER:
 CMP.B #$39,$FFFC02
 BNE FOREVER

EXIT:
 MOVE.W #$2700,SR
 MOVE.L OVBL,$70
 MOVE.W #$2300,SR
 BSR REMOVERAST

; MOVE.W #6,-(SP)
; MOVE.W #27,-(SP)
; TRAP #14
; ADDQ.L #4,SP

 MOVE.W #5,-(SP)
 MOVE.W #27,-(SP)
 TRAP #14
 ADDQ.L #4,SP

 PEA ALLON
 CLR.W -(SP)
 MOVE.W #25,-(SP)
 TRAP #14
 ADDQ.L #8,SP

 MOVE.W #1,-(SP)
 PEA SCR
 PEA SCR
 MOVE.W #5,-(SP)
 TRAP #14
 ADD.L #12,SP

 LEA OLPAL,A0
 LEA $FF8240,A1
 MOVEQ #7,D0
 BSR COPY

 MOVE.L SSP,-(SP)
 MOVE.W #$20,-(SP)
 TRAP #1
 ADDQ.W #6,SP
 ILLEGAL
COPY:
 MOVE.L (A0)+,(A1)+
 DBRA D0,COPY
 RTS

VBL:
 MOVE.W #0,$FF8240
 CLR.B $FFFA1B
 MOVEQ #90,D0
 MOVE.B D0,$FFFA21
 MOVE.B #8,$FFFA1B

 LEA PAL,A0
 LEA $FF8240+32,A1
 MOVEM.L (A0)+,D0-D7
 MOVEM.L D0-D7,-(A1)

 LEA SCREENS,A0
 MOVE.L (A0),D0
 MOVE.L 4(A0),D1
 EXG D0,D1
 MOVE.L D0,(A0)+
 MOVE.L D1,(A0)
 MOVE.L D0,A6

 JSR GETDOWN
 JSR FFSPRITE
 JSR SCROLL
 JSR MUSIC+246

 MOVE.B SCREENS+1+4,$FF8201
 MOVE.B SCREENS+2+4,$FF8203
 RTE

GETDOWN:
GETPEK:
 LEA SCRBUF,A0
ADPEK:
 LEA SCRAD,A2
 CLR.W D0

 MOVEQ #0,D6
 MOVEQ #19,D1
DOWNLOP:
 MOVE.B #%11000000,D7
 MOVE.L A6,A1
 JSR ONECOLUMN

 MOVE.B #%00110000,D7
 ADDQ.W #2,D0
 MOVE.L A6,A1
 JSR ONECOLUMN

 MOVE.B #%00001100,D7
 ADDQ.W #2,D0
 MOVE.L A6,A1
 JSR ONECOLUMN

 MOVE.B #%00000011,D7
 ADDQ.W #2,D0
 MOVE.L A6,A1
 JSR ONECOLUMN

 ADDQ.W #1,A0
 MOVE.B #%11000000,D7
 SUBQ.W #5,D0
 MOVE.L A6,A1
 JSR ONECOLUMN

 MOVE.B #%00110000,D7
 ADDQ.W #2,D0
 MOVE.L A6,A1
 JSR ONECOLUMN

 MOVE.B #%00001100,D7
 ADDQ.W #2,D0
 MOVE.L A6,A1
 JSR ONECOLUMN

 MOVE.B #%00000011,D7
 ADDQ.W #2,D0
 MOVE.L A6,A1
 JSR ONECOLUMN

 ADD.W #31,A0
 ADDQ.W #1,D0
 DBRA D1,DOWNLOP

 RTS

ONECOLUMN:
 ADD.W D0,A1
 ADD.W (A2)+,A1
 MOVE.B D6,-160(A1)
 MOVE.B D6,-320(A1)
 MOVE.B (A0),D2
 MOVE.B 2(A0),D3
 MOVE.B 4(A0),D4
 MOVE.B 6(A0),D5
 AND.B D7,D2
 MOVE.B D2,(A1)
 AND.B D7,D3
 MOVE.B D3,160(A1)
 AND.B D7,D4
 MOVE.B D4,320(A1)
 AND.B D7,D5
 MOVE.B D5,480(A1)

 MOVE.B 8(A0),D2
 MOVE.B 10(A0),D3
 MOVE.B 12(A0),D4
 MOVE.B 14(A0),D5
 AND.B D7,D2
 MOVE.B D2,640(A1)
 AND.B D7,D3
 MOVE.B D3,800(A1)
 AND.B D7,D4
 MOVE.B D4,960(A1)
 AND.B D7,D5
 MOVE.B D5,1120(A1)

 MOVE.B 16(A0),D2
 MOVE.B 18(A0),D3
 MOVE.B 20(A0),D4
 MOVE.B 22(A0),D5
 AND.B D7,D2
 MOVE.B D2,1280(A1)
 AND.B D7,D3
 MOVE.B D3,1440(A1)
 AND.B D7,D4
 MOVE.B D4,1600(A1)
 AND.B D7,D5
 MOVE.B D5,1760(A1)

 MOVE.B 24(A0),D2
 MOVE.B 26(A0),D3
 MOVE.B 28(A0),D4
 MOVE.B 30(A0),D5
 AND.B D7,D2
 MOVE.B D2,1920(A1)
 AND.B D7,D3
 MOVE.B D3,2080(A1)
 AND.B D7,D4
 MOVE.B D4,2240(A1)
 AND.B D7,D5
 MOVE.B D5,2400(A1)
 MOVE.B D6,2560(A1)
 MOVE.B D6,2720(A1)
 RTS

FFSPRITE:
 MOVE.L A6,A1
FFPEK:
 ADD.L #20*160,A1
 LEA SPRITE,A0

 MOVEQ #19,D2
 MOVEQ #32,D1
 MOVEQ #0,D0
FFC1:
 MOVE.L D0,(A1)
 MOVE.W D0,4(A1)
 MOVE.L D0,8(A1)
 MOVE.W D0,12(A1)
 MOVE.L D0,16(A1)
 MOVE.W D0,20(A1)
 MOVE.L D0,24(A1)
 MOVE.W D0,28(A1)
 ADD.W D1,A1
 DBRA D2,FFC1

 MOVE.W #160,D1
 MOVEQ #42,D0
FFLOP1:
 MOVE.L (A0)+,(A1)
 MOVE.W (A0)+,4(A1)
 MOVE.L (A0)+,8(A1)
 MOVE.W (A0)+,12(A1)
 MOVE.L (A0)+,16(A1)
 MOVE.W (A0)+,20(A1)
 MOVE.L (A0)+,24(A1)
 MOVE.W (A0)+,28(A1)
 MOVE.L (A0)+,32(A1)
 MOVE.W (A0)+,36(A1)
 MOVE.L (A0)+,40(A1)
 MOVE.W (A0)+,44(A1)
 MOVE.L (A0)+,48(A1)
 MOVE.W (A0)+,52(A1)
 MOVE.L (A0)+,56(A1)
 MOVE.W (A0)+,60(A1)
 MOVE.L (A0)+,64(A1)
 MOVE.W (A0)+,68(A1)
 MOVE.L (A0)+,72(A1)
 MOVE.W (A0)+,76(A1)
 MOVE.L (A0)+,80(A1)
 MOVE.W (A0)+,84(A1)
 MOVE.L (A0)+,88(A1)
 MOVE.W (A0)+,92(A1)
 MOVE.L (A0)+,96(A1)
 MOVE.W (A0)+,100(A1)
 MOVE.L (A0)+,104(A1)
 MOVE.W (A0)+,108(A1)
 MOVE.L (A0)+,112(A1)
 MOVE.W (A0)+,116(A1)
 MOVE.L (A0)+,120(A1)
 MOVE.W (A0)+,124(A1)
 MOVE.L (A0)+,128(A1)
 MOVE.W (A0)+,132(A1)
 MOVE.L (A0)+,136(A1)
 MOVE.W (A0)+,140(A1)
 MOVE.L (A0)+,144(A1)
 MOVE.W (A0)+,148(A1)
 MOVE.L (A0)+,152(A1)
 MOVE.W (A0)+,156(A1)
 ADD.W D1,A1
 DBRA D0,FFLOP1

 MOVEQ #19,D2
 MOVEQ #32,D1
 MOVEQ #0,D0
FFC2:
 MOVE.L D0,(A1)
 MOVE.W D0,4(A1)
 MOVE.L D0,8(A1)
 MOVE.W D0,12(A1)
 MOVE.L D0,16(A1)
 MOVE.W D0,20(A1)
 MOVE.L D0,24(A1)
 MOVE.W D0,28(A1)
 ADD.W D1,A1
 DBRA D2,FFC2

 CLR.W D0
FFPEK2:
 MOVE.B FFSIN,D0
 CMP.B #$FF,D0
 BNE FFSKP
 MOVE.L #FFSIN,FFPEK2+2
 MOVE.B FFSIN,D0
FFSKP:
 MULU #160,D0
 MOVE.L D0,FFPEK+2
 ADDQ.L #1,FFPEK2+2

 RTS


NEGGER:        ;HANDLER FOR NEGATIVE VALUES
 CMP.W #$-1,D5
 BEQ NEG3
 CMP.W #$-2,D5
 BEQ NEG1
 CMP.W #$-3,D5
 BEQ NEG2
 BCLR #15,D5
 SUB.W D5,A0
 JMP NEGBACK
NEG3:
 MOVE.L #SCTAB,SCPEK1+2
 LEA SCTAB,A3
 JMP LOP10
NEG1:
 MOVE.L #64,ADSK4+2 ;MOVE SCROLLER
 JMP LOP10
NEG2:               ;FREEZE SCROLLER
 MOVE.L #0,ADSK4+2
 JMP LOP10

SCROLL:
 MOVEQ #2,D0
 MOVEQ #0,D1
 LEA SCRBUF,A1
SCPEK1:
 LEA SCTAB,A3
SCPEK2:
 LEA GRAF,A2
 MOVEQ #15,D4
LOP10:
 MOVE.L A2,A0
 MOVE.W (A3)+,D5
 BTST #15,D5
 BNE NEGGER
 ADD.W D5,A0
NEGBACK:
 ADD.W D1,A0
 MOVE.W (A0),(A1)
 MOVE.W 256(A0),32(A1)
 MOVE.W 512(A0),64(A1)
 MOVE.W 768(A0),96(A1)
 MOVE.W 1024(A0),128(A1)
 MOVE.W 1280(A0),160(A1)
 MOVE.W 1536(A0),192(A1)
 MOVE.W 1792(A0),224(A1)
 MOVE.W 2048(A0),256(A1)
 MOVE.W 2304(A0),288(A1)
 MOVE.W 2560(A0),320(A1)
 MOVE.W 2816(A0),352(A1)
 MOVE.W 3072(A0),384(A1)
 MOVE.W 3328(A0),416(A1)
 MOVE.W 3584(A0),448(A1)
 MOVE.W 3840(A0),480(A1)
 MOVE.W 4096(A0),512(A1)
 MOVE.W 4352(A0),544(A1)
 MOVE.W 4608(A0),576(A1)
 MOVE.W 4864(A0),608(A1)
 MOVE.W 5120(A0),640(A1)
 ADD.W D0,A1
 ADD.W D0,D1
 DBRA D4,LOP10

 ADD.L #2,SCPEK1+2

ADPEK4:       ;ACTUAL SCROLLER
 CMP.L #GRAF+(8*(CHARS*32)),SCPEK2+2
 BLO ADSK4
 MOVE.L #GRAF-64,SCPEK2+2
ADSK4:  ;PEK!
 ADD.L #64,SCPEK2+2

 MOVE.L ADPEK+2,A0    ;SIN ADVANCE
 ADDQ.L #2,A0
 CMP.L #SCRAD+720,A0
 BNE ADSKIP
 MOVE.L #SCRAD,A0
ADSKIP:
 MOVE.L A0,ADPEK+2

 RTS


PRESCROLL:
 LEA ASCCI,A2
 LEA GRAF+32,A1
PRE1:
 CLR.W D0
 MOVE.B (A2)+,D0
 TST.B D0
 BEQ ASCFIN
 SUB.B #32,D0
 LSL.W #5,D0
 LEA FONT,A0
 ADD.W D0,A0
 MOVEM.L (A0)+,D0-D7
 MOVEM.L D0-D7,-(A1)
 ADD.W #64,A1
 MOVEM.L D0-D7,-(A1)
 ADD.W #64,A1
 MOVEM.L D0-D7,-(A1)
 ADD.W #64,A1
 MOVEM.L D0-D7,-(A1)
 ADD.W #64,A1
 MOVEM.L D0-D7,-(A1)
 ADD.W #64,A1
 MOVEM.L D0-D7,-(A1)
 ADD.W #64,A1
 MOVEM.L D0-D7,-(A1)
 ADD.W #64,A1
 MOVEM.L D0-D7,-(A1)
 ADD.W #64,A1
 BRA PRE1
ASCFIN:
 SUB.L #30*(8*32),A1
 MOVE.L A1,ADPEK4+2  ;SAVE END ADRESS FOR REFERENCE

 MOVEQ #6,D5      ;PRE-SCROLL SCROLLER
 MOVEQ #1,D4
 LEA GRAF+32,A2
PRE5:
 MOVE.W D4,D3
 BSR PRESUB
 ADDQ.W #2,D4
 ADD.W #32,A2
 DBRA D5,PRE5

 LEA SPEEDSIN,A0     ;TRANSLATE SINTAB
 LEA SCTAB,A1
 LEA GRAF,A2
PRE8:
 CLR.L D0
 MOVE.B (A0)+,D0
 CMP.B #$FF,D0
 BEQ PRE6
 CMP.B #$-2,D0
 BNE PRE9
 MOVE.W #$-2,(A1)+
 BRA PRE8
PRE9:
 CMP.B #$-3,D0
 BNE PRE10
 MOVE.W #$-3,(A1)+
 BRA PRE8
PRE10:
 BTST #7,D0
 BEQ PRE11
 BCLR #7,D0
 LSL.W #5,D0
 BSET #15,D0
 MOVE.W D0,(A1)+
 BRA PRE8
PRE11:
 MOVE.W D0,D1
 LSL.W #5,D1
 MOVE.W D1,(A1)+
 BRA PRE8
PRE6:
 MOVE.W #-1,(A1)+
 RTS

PRESUB:
 MOVE.L A2,A3
 ADD.L #8*(CHARS*32),A2
 MOVE.L #8*32,D1
PRE4:
 MOVEQ #15,D2
PRE3:
 MOVE.L A2,A0
 MOVE #0,CCR
 MOVE.W #CHARS,D0
PRE2:
 ROXL.W (A0)
 SUB.L D1,A0
 DBRA D0,PRE2
 ADDQ.W #2,A2
 DBRA D2,PRE3
 SUB.W #32,A2
 DBRA D3,PRE4
 MOVE.L A3,A2
 RTS

INITRAST:
 MOVE.L $120,SPAR2
; MOVE.L $118,SPAR3
 MOVE.B $FFFA09,SPAR4
 MOVE.B $FFFA07,SPAR4+1
 MOVE.B $FFFA13,SPAR4+2
; MOVE.L #RASTER3,$118
; ANDI.B #-$21,$FFFA09
; ANDI.B #-2,$FFFA07
 MOVE.L #RASTER1,$120
 ORI.B #1,$FFFA07
 ORI.B #1,$FFFA13
 RTS

REMOVERAST:
 MOVE.B SPAR4,$FFFA09
 MOVE.B SPAR4+1,$FFFA07
 MOVE.B SPAR4+2,$FFFA13
 MOVE.L SPAR2,$120
; MOVE.L SPAR3,$118
 RTS

RASTER1:
 MOVE.L #$00700070,$FF8242
 MOVE.W #$0070,$FF8248
 MOVE.W #$0070,$FF8250
 BCLR #0,$FFFA0F
 RTE

RASTER3:
 MOVE.B $FFFC02,DUMM
 BTST #4,$FFFA01
 BEQ RASTER3
 BCLR #6,$FFFA11
 RTE
DUMM: DC.W 0

PAL:
 DC.W $000,$773,$770,$760,$660,$650,$550,$540
 DC.W $007,$017,$027,$037,$047,$057,$067,$077
SSP:
 DC.L 0
OLPAL:
 DS.L 8
OVBL:
 DC.L 0

ADDER: DC.W 0
SPAR1: DC.L 0
SPAR2: DC.L 0
SPAR3: DC.L 0
SPAR4: DC.L 0
SPAR5: DC.W 0

SCREENS:
 DC.L SCR,SCR1

L=160
SCRAD:
 IBYTES SINTAB1.DAT
 DS.W 80,L*100

X=(CHARS*32)
Y EQU GRAF

SPEEDSIN:
 DS.B 100,1
 IBYTES SPEDSIN1.DAT
 DC.B $FF
 ALIGN.W

NOPS:
 DS.L 8,0

ASCCI:
 DS.B 30,' '
 DC.B 'HEY LOOK! JUST LIKE THE XXX WAVE SCROLLER! ONLY ONE THING, THAT '
 DC.B "SCROLLER WAS GOOD, THIS ONE ISN'T! TODAYS DATE IS 890511, BUT I (STALIN) MADE "
 DC.B "THIS SCROLLER TWO MONTHS AGO. FLEXIBLE FRONT LOGO WAS DRAWN BY EARTHLIGHT. "
 DC.B "NOT WORTH TYPING SOMETHING INTERESTING HERE SINCE YOU HAVE ALREADY PRESSED SPACE AND "
 DC.B "SKIPPED THIS SCREEN. (THE TRUE REASON IS THAT I AM TIRED!) GO READ ANOTHER SCROLLTEXT. "
 DC.B "BYE...  "
 DS.B 30,' '
 DC.B 0
ASCSLUT:
 ALIGN.W

ALLOFF: DC.B $12,$1A
ALLON:  DC.B 8,0

FFSIN:
 IBYTES FFSIN1.DAT
 DC.B $FF
 ALIGN.W

MUSIC:
 IBYTES BMX.MUS

SPRITE:
 IBYTES GOLDFF2.PIC
FONT:
 IBYTES SMALLFNT.DAT
GRAF:
SCTAB EQU GRAF+(8*(32*CHARS))+1000
 END

 